package org.bm.p2p.navigablep2p;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;

import org.apache.log4j.Logger;

/**
 * 
 * @author duanshuiliu
 * еĽڵ
 *
 */
public class Node {
	static final int BUCKETS = 16; // Ͱ(ֵ32ıҲ168)
	static final int K = 3; // ÿͰԪظ

	static Logger logger = Logger.getLogger(Node.class.getName());
	
	private int failNum = 0;
	
	private BitSet nodePosition; //ڵλ

	private ArrayList<Node> neighbors[]; // ھӽڵб[ĳԪֵǾǸýڵͱڵľ]
	
	// ΪdistanceĽڵneighborھӽڵб
	public void setNeighbor(Node neighbor, int distance) {
		int i;
		if (distance < 0) return;
		// ͰûѸýڵͰ
		if (neighbors[distance].size() < K) {
			for (i = 0; i < neighbors[distance].size(); i++) {
				if (neighbors[distance].get(i)==neighbor){
					failNum ++;
					return;
				}
			}
			neighbors[distance].add(neighbor);
		}
		else {
			//ͰͰѡһ̭̭㷨ʹãο Kadmelia
			Random random = new Random();
			int chosedIdx = random.nextInt(K+1);
			if (chosedIdx < K)
				neighbors[distance].set(chosedIdx, neighbor);
			
		}
	}
	// þΪdistanceĳھ()
	public Node getNeighbor(int distance) {
		if (distance >=0&&neighbors[distance].size() > 0) {
			Random random = new Random();
			return neighbors[distance].get(random.nextInt(neighbors[distance].size()));
		}
		return null;
	}

	// þĿڵtargetNodeھ
	public Node getNeighbor(Node targetNode) {
		Node neighbor = null;
		int distance = this.getDistanceFrom(targetNode);
		int minDistance = distance;
		if (distance>=0&&neighbors[distance].size() > 0) {
			for (int i = 0; i < neighbors[distance].size(); i++) {
				if (neighbors[distance].get(i).getDistanceFrom(targetNode) < minDistance) {
					minDistance = neighbors[distance].get(i).getDistanceFrom(targetNode);
					neighbor = neighbors[distance].get(i);
				}
			}
		}
		return neighbor;
	}

	// þΪdistanceھ
	public ArrayList<Node> getNeighbors(int distance) {
		return neighbors[distance];
	}
	
	//ʼڵ㣬λΪֵ
	@SuppressWarnings("unchecked")
	public Node() {
		super();
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandom();
		this.neighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++)
			neighbors[i] = new ArrayList<Node>();
		//System.out.println(nodePosition);
	}

	//ʼڵ㣬λúͽڵnodeľdistanceѡȡ
	@SuppressWarnings("unchecked")
	public Node(Node node, int distance) {
		super();
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandomByDistance(node, distance);
		this.neighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++)
			neighbors[i] = new ArrayList<Node>();
		//System.out.println(nodePosition);
	}

	@SuppressWarnings("unchecked")
	public Node(BitSet nodePosition) {
		super();
		this.nodePosition = nodePosition;
		this.neighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++)
			neighbors[i] = new ArrayList<Node>();
	}

	// ɽڵλ
	public void setNodePositionRandom() {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS<32)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		for (i =0 ; i < ((BUCKETS<32)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS<32)?BUCKETS:32); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}
	
	//ɺͽڵnodeľΪdistanceĽڵλ
	public void setNodePositionRandomByDistance(Node node, int distance) {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS==16)||(BUCKETS==8)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		assert(distance<BUCKETS&&distance>=0); // λ[0, BUCKETS-1]
		for (i =0 ; i < ((BUCKETS==16)||(BUCKETS==8)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS==8)?8:(BUCKETS==16?16:32)); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
		// Ӧλλ
		i = Node.BUCKETS-1;
		while (i>distance) {
			nodePosition.set(i, node.getNodePosition().get(i));
			i--;
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}

	public BitSet getNodePosition() {
		return nodePosition;
	}

	public void setNodePosition(BitSet nodePosition) {
		this.nodePosition = nodePosition;
	}
	
	// ͽڵnode֮ľ
	public int getDistanceFrom(Node node) {
		int ret = 0;
		// cloneڵ㣨ΪڼĹУxorڵľҪı䣩
		BitSet twinPosition = (BitSet) this.nodePosition.clone();
		twinPosition.xor(node.getNodePosition());
		ret = twinPosition.length() - 1;
		return ret;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((nodePosition == null) ? 0 : nodePosition.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Node other = (Node) obj;
		if (nodePosition == null) {
			if (other.nodePosition != null)
				return false;
		} else if (!nodePosition.equals(other.nodePosition))
			return false;
		return true;
	}
	
	// ڵھӽڵ
	public void outputNeighbors() {
		for (int i = 0; i < BUCKETS; i++) {
			if (neighbors[i].size()>0) {
				for (int j = 0; j < neighbors[i].size(); j++) {
					logger.info("neighbor "+i+"-"+j+" : "+neighbors[i].get(j).getNodePosition());
				}
			}
		}
	}

	// ýڵھӸ
	public int getNeighborNum() {
		int neighborNum = 0;
		for (int i = 0; i < BUCKETS; i++)
			neighborNum += neighbors[i].size();
		return neighborNum;
	}
	
	public double getFailNum() {
		return failNum;
	}
}
